 ; Ŀ
 ;   Tic - centre single text entities in circles.                         
 ;   Copyright 2001, 2005, 2006, 2010 by Rocket Software Ltd.              
 ;   A routine so good you'll be nervous...                                
 ; 

 ; Ŀ
 ;   Bock: find the box bounding the selection set of text or attdef       
 ;   entities which is passed as the sole argument.                        
 ; 
 (DEFUN BOCK (ss / num enam typ entt mxlst xmax xmin ymax ymin pl)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq typ (cdr (assoc 0 (entget enam))))
         (setq mxlst (cron enam 0))
         (if xmax
             (setq xmax (max xmax (car mxlst)))
             (setq xmax (car mxlst)))
         (if xmin
             (setq xmin (min xmin (cadr mxlst)))
             (setq xmin (cadr mxlst)))
         (if ymax
             (setq ymax (max ymax (caddr mxlst)))
             (setq ymax (caddr mxlst)))
         (if ymin
             (setq ymin (min ymin (cadddr mxlst)))
             (setq ymin (cadddr mxlst))))
  (list (list xmin ymin) (list xmax ymax)))
 ; Ŀ
 ;   Bock end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Cfind - find all text entities mostly in a circle.         
 ;   Takes two arguments: the circle centre and radius.                    
 ;   Returns an ss or nil.                                                 
 ; 
 (DEFUN CFIND (ccen crab / ang ptlis ss)
  (setq ang 0)
  (while (<= ang (* pi 2))
         (setq ptlis (cons (polar ccen ang crab) ptlis))
         (setq ang (+ ang (/ pi 16))))
  (setq ss (ssget "cp" ptlis (list (cons 0 "text"))))
 ss)
 ; Ŀ
 ;   Cfind end.                                                            
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Mover - move an ss from one point to another while rotating it 360    
 ;   degrees.  Takes three arguments, a base point, a new point, and the   
 ;   ss name.  Returns nothing of use.                                     
 ; 
 (DEFUN MOVER (pa gnupt ss / dist angg)
  (setq jumps 30)
  (setq dist (/ (distance pa gnupt) jumps))
  (setq angg (angle pa gnupt))
  (repeat jumps
          (command ".move" ss "" "0,0" (polar (list 0 0) angg dist))
          (command ".rotate" ss "" pa (/ 360.0 jumps))
          (setq pa (polar pa angg dist))))
 ; Ŀ
 ;   Mover end.                                                            
 ; 

 ; Ŀ
 ;   VBMX - Centre rejustify a column of text.                             
 ;   Takes three arguments: ss, the set of entities to rejustify, cc, the  
 ;   left side point, and rr, the right point.                             
 ; 
 (DEFUN VBMX (ss cc rr / xa num enam entt ten pty pa sp)
  (setq xa (/ (+ (car cc) (car rr)) 2))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))            ; get entity data
         (setq ten (cdr (assoc 10 entt)))     ; save 10 point
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 72 4) (assoc 72 entt) entt))  ; change
         (setq entt (entget enam))            ; get changed edata
         (setq new10 (cdr (assoc 10 entt)))   ; new 10 point
         (setq dist (distance ten new10))     ; distance moved
         (setq angl (angle new10 ten))        ; and angle
         (setq new11 (cdr (assoc 11 entt)))   ; new middle point
         (setq new11 (polar new11 angl dist)) ; move middle as 10 was
         (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
         (setq entt (entget enam))            ; get entity data
         (setq pty (cddr (assoc 11 entt)))    ; final middle y coord
         (setq pa (cons xa pty))              ; final middle point
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   VBMX end.                                                             
 ; 

 ; Ŀ
 ;   Vortex - mark a point passed as the only argument.                    
 ; 
 (DEFUN VORTEX (pa rad colo / reps pa rad2 angg incr)
  (if (= colo 0) (setq colo 4))
  (setq reps 75)
  (setq rad2 (* rad 4))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq ang2 (+ angg (/ pi 5)))
          (grdraw (polar pa angg rad2) (polar pa ang2 rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Vortex end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Ctea - centre text on a point.                             
 ;   Hacked from the routine C:Tea.                                        
 ;   Copyright 1995, 1997 by Rocket Software                               
 ;   Takes two arguments: an ss of text and a point.                       
 ;   Doesn't adjust vertical spacing.                                      
 ; 
 (DEFUN CTEA (ss pa / pts ll ur pa1 rad)
  (setq pts (bock ss))        ; added code to rejustify on block
  (setq bp1 (car pts))        ; of text rather than on sides of box
  (setq bp2 (cadr pts))       ; strictly
  (vbmx ss bp1 bp2)           ; for looks
  (setq pts (bock ss))
  (setq ll (car pts))
  (setq ur (cadr pts))
  (setq pa1 (polar ll (angle ll ur) (setq rad (/ (distance ll ur) 2.0))))
  (mover pa1 pa ss)
 (princ))
 ; Ŀ
 ;   Ctea end.                                                             
 ; 

 ; Ŀ
 ;   Tic.                                                                  
 ; 
 (DEFUN C:TIC (/ rad snapp osmo *error* ss len num enam entt ccen crab ssc)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq rad (/ (getvar "viewsize") 35))
 ; Ŀ
 ;   Turn off snap, rehash settings, etc.                                  
 ; 
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (if shk (print shk))
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Get an ss of circles.                                                 
 ; 
  (prompt "Select some circles: ")
  (if (setq ss (ssget (list (cons 0 "circle"))))
      (setq len (strcat "/" (itoa (sslength ss)))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext 0 (strcat (itoa (setq num (1+ num))) len))
         (setq entt (entget enam))
         (setq ccen (cdr (assoc 10 entt)))
         (setq crab (cdr (assoc 40 entt)))
         (if (setq ssc (cfind ccen crab))
             (progn
                  (ctea ssc ccen)
                  (vortex ccen crab num))))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 (princ))